#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "CFunctions.h"

unsigned int bcd2_to_int(const char* bcd) {
  unsigned char a = bcd[1] - '0', b = bcd[0] - '0';
  if( a < 10 ) {
    if( b < 10 )
      return b * 10 + a;
    else
      return a;
  }
  return 0;
}

static unsigned int get_dow(unsigned int day, unsigned int mon, unsigned int year) {
  static const unsigned char mon_table[12] = { 0, 3, 3, 6, 1, 4, 6, 2, 5, 0, 3, 5 };
  unsigned int yearmod = year, ret;
  while( yearmod > 28 )
      yearmod -= 28;
  ret = day + mon_table[mon-1] + yearmod + (yearmod>>2);
  if( mon <= 2 && !(year&3) )
    --ret;
  return (ret+6)%7;
}

static int compare_times(unsigned int hour, unsigned int min, const char* time) {
  unsigned int t_hour = bcd2_to_int(time);
  unsigned int t_min = bcd2_to_int(time+2);
  if( t_hour == hour )
    return (int)min - (int)t_min;
  else
    return (int)hour - (int)t_hour;
}

void __pic32_software_reset() {
}

long long int main(const char* date, const char* time, const char* tariff_times, const char* holidays) {
  unsigned int i, day, mon, year, hour, min/*, sec*/, dow, offset;
  day = bcd2_to_int(date+1);
  mon = bcd2_to_int(date+1+3);
  year = bcd2_to_int(date+1+8);
  dow = get_dow(day, mon, year);
  hour = bcd2_to_int(time+1);
  min = bcd2_to_int(time+1+3);
//  sec = bcd2_to_int(time+1+6);
  if( dow > 0 && dow < 6 ) {
    for( i = 0; i < 22; ++i ) {
      int holday, holmon, holyear;
      holday = bcd2_to_int(holidays+1 + i*6);
      holmon = bcd2_to_int(holidays+1 + i*6 + 2);
      holyear = bcd2_to_int(holidays+1 + i*6 + 4);
      if( holday == day && holmon == mon && holyear == year ) {
        // it's a public holiday, woohoo
        dow = 0;
        break;
      }
    }
  }
  offset = (dow == 0 || dow == 6 ? 16 : 0);
  for( i = 0; i < 16; i += 8 ) {
    if( tariff_times[offset+1+i+3] != ' ' && compare_times(hour, min, tariff_times+1 + offset+i) >= 0 &&
        tariff_times[offset+1+i+7] != ' ' && compare_times(hour, min, tariff_times+1 + offset+i+4)< 0 )
      return 3; // peak time
  }
  for( i = 0; i < 16; i += 8 ) {
    if( tariff_times[offset+1+32+i+3] != ' ' && compare_times(hour, min, tariff_times+1 + offset+32+i) >= 0 &&
        tariff_times[offset+1+32+i+7] != ' ' && compare_times(hour, min, tariff_times+1 + offset+32+i+4)< 0 )
      return 2; // shoulder time
  }
  return 1; // off-peak time
}
